  import simpleDist.*;
  import java.util.*;
  import java.io.*;
  import java.lang.*;

  public class StockClient extends Client{

  public static void main(String[] args) throws Exception{

    //Connect to your server
    connect("127.0.0.1",1001);

    //Get the catalogue of articles for auction from the server

    String choice ="";
    while (!choice.equals("q")){

      showMenu();

      choice = getString();
      if (choice.equals("e")){
        //add new
        send("stockLevel");				//Command
        System.out.print("Enter Serial number\t");
        send(getString());			//Item serial Number
        System.out.println(receive());		//Print out the results
        }

      if (choice.equals("h")){
        //add new
        send("stockHistory");				//Command
        System.out.print("Enter Serial number\t");
        send(getString());			//Item serial Number
        System.out.println(receive());		//Print out the results
        }

      if (choice.equals("a")){
        //Add new stock
        send("addStock");
        System.out.print("Enter serial number\t");
        send(getString());			//Item serial Number
	  System.out.println("Qty to add");
        String q = getString();	                //Inital Qty
        send(new Integer(q));
        send(getDateTime());			//Time of transaction
        System.out.println(receive());		//Find out the status of our command
        }

      if (choice.equals("s")){
       //withdraw
        send("sale");
        System.out.print("Enter serial number\t");
        send(getString());			//Item serial Number
	System.out.println("Qty sold");
        String q = getString();	                //Qty sold
        send(new Integer(q));
        send(getDateTime());			//Time of transaction
        System.out.println(receive());		//Find out the status of our command
        }

      if (choice.equals("l")){
       //withdraw
        send("list");
        System.out.println(receive());		//Find out the status of our command
        }
      
      if (choice.equals("n")){
    	send("newitem");
    	System.out.print("Enter new item serial number\t");
    	String serial = getString();
    	System.out.print("Enter new item description\t");
    	String description = getString();
    	System.out.print("Enter new item location\t");
    	String location = getString();
    	System.out.print("Enter initial stock level\t");
    	//None of the others check for exceptions either... :P
    	int amount = Integer.parseInt(getString());
    	
    	StockItem newItem = new StockItem(serial,description, amount, location);
    	send(newItem);
    	System.out.println(receive());
    	
        }
      }
    
    
      System.exit(0);
    }

    public static String getString(){
      String res= "";
      try{
        InputStreamReader is = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(is);
        res = br.readLine();
      }
      catch(IOException e){
        e.printStackTrace();
      }

      return res;
    }

    public static void showMenu(){
      System.out.println("Stock Control Menu\n");
      System.out.println(getDateTime()+"\n\n");
      System.out.println("\t e - stock level enquiry");
      System.out.println("\t h - item history");
      System.out.println("\t a - add new stock");
      System.out.println("\t n - new stock line");
      System.out.println("\t s - sale");
      System.out.println("\t l - stocklist\n");	
      System.out.println("\t q - disconnect");
    }

   public static String getDateTime(){
    Calendar cal = new GregorianCalendar();
    return ""+cal.get(Calendar.HOUR_OF_DAY)+":"+cal.get(Calendar.MINUTE)+" "+cal.get(Calendar.DAY_OF_MONTH)+"/"+cal.get(Calendar.MONTH)+ "/"+cal.get(Calendar.YEAR); 
    }
  }